<?php

namespace UtillzCore\Inc\Src\Woocommerce;

use \UtillzCore\Inc\Utils\Woocommerce;
use \UtillzCore\Inc\Src\Traits\Singleton;

class Init {

    use Singleton;

    function __construct() {

        Products\Init::instance();
        Products\Subscription::instance();
        Post_Types::instance();
        Cart::instance();
        Checkout::instance();
        Order::instance();

        $this->register_helper();

        add_action('after_setup_theme', [ $this, 'register_account_pages' ]);
        add_action('wp_enqueue_script', [ $this, 'enqueue_script' ]);

        // fix null price
        add_action('woocommerce_update_product', [ $this, 'on_product_update' ], 10, 1);

        // calculate totals
        add_action('woocommerce_before_calculate_totals', [ $this, 'calculate_totals' ]);

    }

    public function on_product_update( $product_id ) {
        $product = wc_get_product( $product_id );

        if( in_array( $product->get_type(), Ucore()->get_listing_product_types() ) ) {
            if( $product->get_regular_price() === '' ) {
                update_post_meta( $product_id, '_price', '0' );
                update_post_meta( $product_id, '_regular_price', '0' );
            }
        }
    }

    static function enqueue_script() {

        wp_enqueue_style('utillz-account');
        wp_enqueue_script('utillz-account');

    }

    public function register_helper() {
        utillz_core()->register( 'wc', Woocommerce::instance() );
    }

    public function register_account_pages() {

        $this->switch_user_role();

        $user_role = get_user_meta( get_current_user_id(), 'ulz_role', true );

        if( $user_role == 'business' ) {
            utillz_core()->wc()->add_account_page([
    			'endpoint' => 'listings',
    			'title' => null,
    			'template' => 'account/listings/listings',
    			'show_in_menu' => true,
    			'order' => 4,
    		]);
        }

        utillz_core()->wc()->add_account_page([
			'endpoint' => 'messages',
			'title' => null,
			'template' => 'account/messages/messages',
			'show_in_menu' => true,
			'order' => 5,
		]);

        utillz_core()->wc()->add_account_page([
			'endpoint' => 'entries',
			'title' => null,
			'template' => 'account/entries/entries',
			'show_in_menu' => true,
			'order' => 6,
		]);

        if( get_option('ulz_enable_payouts') && $user_role == 'business' ) {
            utillz_core()->wc()->add_account_page([
    			'endpoint' => 'payouts',
    			'title' => null,
    			'template' => 'account/payouts/payouts',
    			'show_in_menu' => true,
    			'order' => 7,
    		]);
        }

        utillz_core()->wc()->add_account_page([
			'endpoint' => 'notification-settings',
			'title' => null,
			'template' => 'account/notifications/notifications',
			'show_in_menu' => true,
			'order' => 8,
		]);

        utillz_core()->wc()->add_account_page([
			'endpoint' => 'assets',
			'title' => null,
			'template' => 'account/assets/assets',
			'show_in_menu' => true,
			'order' => 8,
		]);

    }

    public function switch_user_role() {
        if( isset( $_GET['ulz_switch_user_role'] ) ) {

            if( get_option('ulz_enable_standard_role') ) {
                $user_id = get_current_user_id();
                $user_current_role = get_user_meta( $user_id, 'ulz_role', true );
                update_user_meta( $user_id, 'ulz_role', ( empty( $user_current_role ) || $user_current_role == 'customer' ) ? 'business' : 'customer' );
            }

            wp_redirect( wc_get_account_endpoint_url( 'dashboard' ) );
            exit;

        }
    }

    public function calculate_totals( $cart ) {

        if( empty( $cart->cart_contents ) ) {
            return;
        }

        foreach( $cart->cart_contents as $key => $value ) {
            $type = $value['data']->get_type();
            if( in_array( $type, Ucore()->get_listing_product_types() ) ) {
                if( isset( $value['processing'] ) ) {
                    $value['data']->set_price( floatval( $value['processing'] ) );
                }
            }
        }

    }

}
